# Song Voter Widget v1.1.0 - Quick Start Guide

## 🎉 What's New in v1.1.0

Now you can use Song Voter Widget in **THREE different ways**:

1. **Gutenberg Block** - For WordPress block editor users
2. **Shortcode** - For classic editor or anywhere in WordPress
3. **Elementor Widget** - For Elementor page builder users (optional)

**The plugin now works WITHOUT Elementor!**

---

## Installation

1. Go to WordPress Admin → Plugins → Add New → Upload Plugin
2. Upload `song-voter-widget.zip`
3. Click "Install Now" then "Activate"
4. Done! No other plugins required (unless you want to use Elementor)

---

## Usage Methods

### Method 1: Gutenberg Block (Recommended for Block Editor)

**Step-by-step:**
1. Edit any post or page
2. Click the '+' button to add a new block
3. Type "Song Voter" in the search
4. Click on the "Song Voter" block
5. Click "Select Audio File" button
6. Choose your MP3 from the media library
7. (Optional) Adjust settings in the right sidebar:
   - Toggle "Show Filename" on/off
   - Set custom width (e.g., "500px" or "80%")
8. Publish!

---

### Method 2: Shortcode (Works Everywhere)

**Basic usage:**
```
[song_voter id="123"]
```

**Finding your media ID:**
1. Go to Media → Library
2. Click on your audio file
3. Look at the browser URL
4. Find the number after `post=`
   - Example URL: `post.php?post=456`
   - Your ID is: `456`

**Advanced usage with parameters:**
```
[song_voter id="123" show_filename="false" width="600px"]
```

**Parameters:**
- `id` - Required. The media attachment ID
- `show_filename` - Optional. "true" or "false" (default: "true")
- `width` - Optional. Any CSS width value (default: "100%")

**Where to use shortcodes:**
- Posts and pages (anywhere in content)
- Text widgets
- Custom HTML blocks
- Page builders that support shortcodes

---

### Method 3: Elementor Widget (If You Have Elementor)

**Step-by-step:**
1. Edit page with Elementor
2. Search for "Song Voter" in left panel
3. Drag widget to page
4. Click "Choose Audio File"
5. Select your MP3
6. Customize in left panel:
   - Content tab: Show/hide filename
   - Style tab: Width and accent color
7. Publish!

---

## How to Get Audio Files

### Upload New Audio:
1. Go to Media → Add New
2. Drag and drop your MP3 file
3. Note the media ID (see "Finding your media ID" above)

### Use Existing Audio:
1. Go to Media → Library
2. Find your file and note its ID

---

## Examples

### Example 1: Simple Shortcode
```
[song_voter id="42"]
```
Shows a player for media ID 42 with filename displayed, full width.

### Example 2: No Filename, Custom Width
```
[song_voter id="99" show_filename="false" width="400px"]
```
Shows player without filename, 400px wide.

### Example 3: In a Column (80% width)
```
[song_voter id="15" width="80%"]
```
Shows player at 80% of container width.

### Example 4: Multiple Players
```
[song_voter id="1"]
[song_voter id="2"]
[song_voter id="3"]
```
Shows three separate players, each with its own voting.

---

## Voting Features

- **Anyone can vote** - Including guests (no login required)
- **One vote per person** - Tracked by browser cookie
- **Change your vote** - Click the other button to switch
- **Remove your vote** - Click same button again to remove
- **Real-time counts** - Vote totals update instantly
- **Visual feedback** - Buttons highlight when you vote

---

## Customization

### For Gutenberg Block:
Use the block settings in the right sidebar.

### For Shortcode:
Use the width parameter:
```
[song_voter id="123" width="500px"]
```

### For Elementor:
Use the Style tab to customize:
- Player width
- Accent color (the blue highlight color)

### For Advanced Users (Custom CSS):
Add to your theme's custom CSS:
```css
.svw-player-container {
    /* Your custom styles */
}

.svw-play-button:hover {
    background: linear-gradient(145deg, #your-color, #darker-color) !important;
}
```

---

## Troubleshooting

**Problem: "Please provide a valid media ID"**
- Solution: Make sure you're using the correct media ID number
- Check Media Library for the right ID

**Problem: "Audio file not found"**
- Solution: The file may have been deleted
- Re-upload the audio file

**Problem: Player not showing**
- Solution: Check if JavaScript is enabled
- Clear browser cache
- Check for JavaScript errors in browser console

**Problem: Votes not saving**
- Solution: Check if cookies are enabled
- Try a different browser

---

## Support

For support, contact: konstantinos@kourentzes.com

---

## Version History

**v1.1.0** (Current)
- Added Gutenberg block
- Added shortcode support
- Works without Elementor
- Better error handling

**v1.0.0**
- Initial release
- Elementor widget only
