# Song Voter Widget

A WordPress plugin that adds voting functionality for MP3 files with a sleek metallic design. Works with Elementor, Gutenberg blocks, and shortcodes.

## Description

Song Voter Widget allows you to create interactive audio players with voting functionality. Visitors can listen to MP3 files and vote with thumbs up or thumbs down. Perfect for music showcases, podcast episodes, or any audio content that needs community feedback.

**Now works in 3 ways:**
1. **Elementor Widget** - Drag and drop widget for Elementor page builder
2. **Gutenberg Block** - Native WordPress block for the block editor
3. **Shortcode** - Use `[song_voter id="123"]` anywhere in your content

## Features

- ✨ Three integration methods: Elementor widget, Gutenberg block, and shortcode
- 🎵 Elegant metallic-themed audio player
- 👍 👎 Thumbs up/down voting system
- 🍪 Cookie-based vote tracking (allows vote changes)
- 📊 Real-time vote count display
- 📱 Fully responsive design
- 🎨 Customizable colors and width
- ⚡ Smooth animations and visual feedback
- 🔒 Basic rate limiting (1 vote per second)
- 🌐 Works with or without Elementor

## Installation

1. Download the plugin files
2. Upload the `song-voter-widget` folder to `/wp-content/plugins/`
3. Activate the plugin through the 'Plugins' menu in WordPress
4. You're ready to go! (Elementor is optional)

## Usage

### Method 1: Gutenberg Block (Block Editor)

1. Edit a post or page with the block editor
2. Click the '+' button to add a block
3. Search for "Song Voter"
4. Click the block to add it
5. Click "Select Audio File" and choose your MP3
6. Customize settings in the sidebar (optional)
7. Publish your page

### Method 2: Shortcode (Classic Editor or anywhere)

Use the shortcode in any post, page, or widget:

```
[song_voter id="123"]
```

**Shortcode Parameters:**
- `id` (required) - The media attachment ID of your audio file
- `show_filename` (optional) - Show/hide filename (default: "true")
- `width` (optional) - Player width (default: "100%")

**Examples:**
```
[song_voter id="123"]
[song_voter id="456" show_filename="false"]
[song_voter id="789" width="500px"]
[song_voter id="101" show_filename="true" width="80%"]
```

**How to find your media ID:**
1. Go to Media Library
2. Click on your audio file
3. Look at the URL - the ID is the number after `post=`
   Example: `post.php?post=123` - your ID is 123

### Method 3: Elementor Widget

1. Edit a page with Elementor
2. Search for "Song Voter" in the widget panel
3. Drag the widget to your desired location
4. Select an MP3 file from your media library
5. Customize the appearance (optional)
6. Publish your page

### Widget Settings (Gutenberg & Elementor)

#### Content Settings
- **Choose Audio File**: Select an MP3 file from the WordPress media library
- **Show Filename**: Toggle to show/hide the file name above the player
- **Width**: Adjust the player width

#### Style Settings (Elementor only)
- **Player Width**: Adjust the maximum width of the player (50-100% or 300-1200px)
- **Accent Color**: Customize the highlight color (default: #4a90e2)

## How Voting Works

- Visitors can click thumbs up or thumbs down to vote
- Votes are tracked using cookies (expires in 1 year)
- Users can change their vote by clicking the other button
- Clicking the same button again removes the vote
- Vote counts are displayed next to each button
- All users (including guests) can vote

## Technical Details

### Database

The plugin creates a custom table `wp_song_votes` with the following structure:
- `id`: Unique identifier
- `media_id`: WordPress media attachment ID
- `thumbs_up`: Total thumbs up count
- `thumbs_down`: Total thumbs down count
- `created_at`: Timestamp of first vote
- `updated_at`: Timestamp of last update

### Rate Limiting

- 1 vote per second per IP address
- Prevents spam voting
- Uses WordPress transients

### Browser Compatibility

- Modern browsers (Chrome, Firefox, Safari, Edge)
- HTML5 audio support required
- JavaScript must be enabled

## Customization

### Custom CSS

You can add custom styles to further customize the player:

```css
.svw-player-container {
    /* Your custom styles */
}
```

### Modifying Colors

Use the Elementor style controls or add custom CSS:

```css
.svw-play-button:hover {
    background: linear-gradient(145deg, #your-color, #your-darker-color);
}
```

## Security Features

- Nonce verification for all AJAX requests
- Data sanitization and validation
- SQL injection prevention using prepared statements
- XSS protection with proper escaping
- Rate limiting to prevent abuse

## Requirements

- WordPress 5.0 or higher
- PHP 7.2 or higher
- Elementor (optional - only needed for Elementor widget)
- HTML5 audio support in browser

## File Structure

```
song-voter-widget/
├── assets/
│   ├── css/
│   │   ├── style.css
│   │   └── block-editor.css
│   └── js/
│       ├── script.js
│       └── block.js
├── includes/
│   ├── class-database.php
│   ├── class-ajax-handler.php
│   ├── class-shortcode.php
│   ├── class-gutenberg-block.php
│   └── class-elementor-widget.php
├── song-voter-widget.php
└── README.md
```

## Changelog

### Version 1.2.0
- **NEW DESIGN**: Song title now integrated inside player widget
- Redesigned layout with title at the top of the player
- Improved visual hierarchy and information display
- Better mobile responsive layout
- Progress bar and time display reordered for better UX
- Title has subtle background gradient for visual separation

### Version 1.1.1
- **CRITICAL FIX**: Fixed voting buttons not working when using shortcode or Gutenberg block
- Simplified asset loading for better reliability
- Assets now load on all frontend pages for maximum compatibility
- Improved JavaScript initialization with fallback loading

### Version 1.1.0
- Added Gutenberg block support for WordPress block editor
- Added shortcode support for use anywhere
- Plugin now works without Elementor
- Improved activation error handling
- Updated documentation with all usage methods

### Version 1.0.0
- Initial release
- Elementor widget integration
- Voting functionality
- Metallic player design
- Cookie-based tracking
- Rate limiting

## Support

For support, please contact: konstantinos@kourentzes.com

## License

GPL v2 or later - https://www.gnu.org/licenses/gpl-2.0.html

## Credits

Author: konstantinos@kourentzes.com
