# Song Voter Widget - Troubleshooting Guide

## Version 1.1.1 Bug Fixes

This version fixes a **critical bug** where voting buttons didn't work when using shortcode or Gutenberg blocks.

### What was fixed:
- ✅ JavaScript and CSS now load properly on all methods
- ✅ AJAX voting now works correctly
- ✅ Better asset enqueuing system
- ✅ Improved initialization with fallback loading

---

## Quick Checks if Buttons Still Don't Work

### 1. Clear Your Cache
**Most common issue!**
- Clear your browser cache (Ctrl+Shift+Delete or Cmd+Shift+Delete)
- Clear WordPress cache (if using a caching plugin)
- Clear any CDN cache (Cloudflare, etc.)

### 2. Check JavaScript Console
1. Right-click on page → "Inspect" or press F12
2. Click "Console" tab
3. Look for any red errors
4. Common issues:
   - "jQuery is not defined" → Your theme might not be loading jQuery
   - "svwAjax is not defined" → Scripts not loading in correct order
   - Any 404 errors → File paths are wrong

### 3. Verify jQuery is Loaded
Add this code temporarily to test:
```javascript
<script>
jQuery(document).ready(function($) {
    console.log('jQuery version:', $.fn.jquery);
    console.log('svwAjax:', typeof svwAjax);
});
</script>
```
Both should show values, not "undefined"

### 4. Check if Scripts are Loading
View page source (Ctrl+U) and search for:
- `song-voter-widget` (should appear in CSS link)
- `script.js` (should appear in script tag)
- `svwAjax` (should appear with nonce and ajaxurl)

---

## Common Issues & Solutions

### Issue: Buttons appear but clicking does nothing

**Solution 1: Update to v1.1.1**
This version specifically fixes this issue.

**Solution 2: Check theme compatibility**
Some themes don't load jQuery properly. Add to your theme's functions.php:
```php
function load_jquery_properly() {
    if (!is_admin()) {
        wp_enqueue_script('jquery');
    }
}
add_action('wp_enqueue_scripts', 'load_jquery_properly', 1);
```

**Solution 3: Disable conflicting plugins**
Try disabling these types of plugins temporarily:
- Lazy loading plugins
- JavaScript optimization/minification plugins
- Asset cleanup plugins

### Issue: "Please provide a valid media ID"

**Solution:**
1. Go to Media → Library
2. Click on your audio file
3. Check the URL: `post.php?post=123` 
4. Use that number: `[song_voter id="123"]`

### Issue: "Audio file not found"

**Solution 1:**
The file might have been deleted. Re-upload it.

**Solution 2:**
Check file permissions. Audio files should be in:
`/wp-content/uploads/`

### Issue: Votes not saving

**Solution 1: Enable cookies**
Voting uses browser cookies. Check:
1. Browser allows cookies for your site
2. Not in private/incognito mode
3. No cookie-blocking extensions active

**Solution 2: Check nonce**
If you see "Invalid security token" in console:
1. Clear all caches
2. Reload the page
3. The nonce regenerates on each page load

### Issue: Player shows but won't play audio

**Solution 1: Check file format**
- Must be MP3 format
- Some browsers don't support certain MP3 encodings
- Try re-encoding with standard settings

**Solution 2: Check CORS**
If audio is on external server, CORS headers might block it.

### Issue: Multiple players on same page interfere

**Solution:**
Each player should have unique media ID. This is handled automatically.
If issues persist, make sure you're using different audio files.

---

## Debugging Mode

To enable detailed logging:

1. Edit `wp-config.php`
2. Add before "That's all, stop editing!":
```php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
define('WP_DEBUG_DISPLAY', false);
```

3. Check `/wp-content/debug.log` for errors

---

## Browser Compatibility

**Supported Browsers:**
- ✅ Chrome 90+
- ✅ Firefox 88+
- ✅ Safari 14+
- ✅ Edge 90+

**Not Supported:**
- ❌ Internet Explorer (any version)
- ❌ Very old mobile browsers

---

## Testing Voting Functionality

### Quick Test:
1. Load page with player
2. Open browser console (F12)
3. Click thumbs up
4. Should see in console: AJAX request to admin-ajax.php
5. Response should show success: true

### Test Vote Change:
1. Click thumbs up (count increases)
2. Click thumbs down (up decreases, down increases)
3. Click thumbs down again (vote removed, count decreases)

### Test Cookie:
1. Vote on a song
2. Reload page
3. Your vote should still show (button highlighted)

---

## Plugin Conflicts

**Known to cause issues:**
- Autoptimize (disable JS optimization for this plugin)
- WP Rocket (exclude script.js from minification)
- Asset CleanUp (don't disable song-voter-widget assets)

**How to exclude from optimization:**

Most optimization plugins have a field for "JS to exclude" or "Scripts to exclude from minification". Add:
```
song-voter-widget
script.js
```

---

## Still Having Issues?

### Information to Provide:

1. **WordPress Version:** (Dashboard → Updates)
2. **PHP Version:** (Tools → Site Health)
3. **Theme Name:**
4. **Active Plugins List:**
5. **Browser Console Errors:** (F12 → Console tab → screenshot)
6. **How you're using it:** (Shortcode / Gutenberg / Elementor)
7. **Example shortcode you're using:**

### Contact:
konstantinos@kourentzes.com

Include the above information for fastest support.

---

## Performance Notes

- CSS file: ~7KB
- JS file: ~6KB
- Total asset load: ~13KB (very lightweight!)
- Assets load on all frontend pages for compatibility
- If this is an issue, use a lazy-load plugin

---

## Advanced: Custom JavaScript Init

If you need to manually initialize players (advanced users only):

```javascript
jQuery(document).ready(function($) {
    // Re-initialize all players
    $('.svw-player-container').each(function() {
        if (!$(this).data('svw-initialized')) {
            new SongVoterWidget($(this));
            $(this).data('svw-initialized', true);
        }
    });
});
```

---

## Changelog

**v1.1.1** - Critical bug fix for voting functionality
**v1.1.0** - Added Gutenberg and Shortcode support  
**v1.0.0** - Initial release
