(function(wp) {
    const { registerBlockType } = wp.blocks;
    const { MediaUpload, InspectorControls } = wp.blockEditor || wp.editor;
    const { Button, PanelBody, ToggleControl, TextControl } = wp.components;
    const { __ } = wp.i18n;
    const { Fragment } = wp.element;
    
    registerBlockType('song-voter-widget/audio-voter', {
        title: __('Song Voter', 'song-voter-widget'),
        icon: 'format-audio',
        category: 'media',
        attributes: {
            mediaId: {
                type: 'number',
                default: 0,
            },
            mediaUrl: {
                type: 'string',
                default: '',
            },
            showFilename: {
                type: 'boolean',
                default: true,
            },
            width: {
                type: 'string',
                default: '100%',
            },
        },
        
        edit: function(props) {
            const { attributes, setAttributes } = props;
            const { mediaId, mediaUrl, showFilename, width } = attributes;
            
            const onSelectMedia = function(media) {
                setAttributes({
                    mediaId: media.id,
                    mediaUrl: media.url,
                });
            };
            
            return (
                wp.element.createElement(Fragment, null,
                    wp.element.createElement(InspectorControls, null,
                        wp.element.createElement(PanelBody, {
                            title: __('Settings', 'song-voter-widget'),
                            initialOpen: true,
                        },
                            wp.element.createElement(ToggleControl, {
                                label: __('Show Filename', 'song-voter-widget'),
                                checked: showFilename,
                                onChange: function(value) {
                                    setAttributes({ showFilename: value });
                                },
                            }),
                            wp.element.createElement(TextControl, {
                                label: __('Width', 'song-voter-widget'),
                                value: width,
                                onChange: function(value) {
                                    setAttributes({ width: value });
                                },
                                help: __('e.g., 100%, 500px', 'song-voter-widget'),
                            })
                        )
                    ),
                    wp.element.createElement('div', {
                        className: 'svw-block-editor-wrapper',
                        style: { 
                            padding: '20px', 
                            border: '2px dashed #ccc', 
                            borderRadius: '8px',
                            textAlign: 'center',
                        }
                    },
                        !mediaId ? (
                            wp.element.createElement(MediaUpload, {
                                onSelect: onSelectMedia,
                                allowedTypes: ['audio'],
                                value: mediaId,
                                render: function(obj) {
                                    return wp.element.createElement(Button, {
                                        onClick: obj.open,
                                        className: 'button button-large',
                                    },
                                        wp.element.createElement('span', {
                                            className: 'dashicons dashicons-format-audio',
                                            style: { marginRight: '8px' }
                                        }),
                                        __('Select Audio File', 'song-voter-widget')
                                    );
                                }
                            })
                        ) : (
                            wp.element.createElement('div', null,
                                wp.element.createElement('p', {
                                    style: { 
                                        fontSize: '14px', 
                                        color: '#555',
                                        marginBottom: '12px',
                                    }
                                },
                                    wp.element.createElement('span', {
                                        className: 'dashicons dashicons-format-audio',
                                        style: { marginRight: '5px' }
                                    }),
                                    __('Audio file selected', 'song-voter-widget')
                                ),
                                mediaUrl && wp.element.createElement('audio', {
                                    controls: true,
                                    src: mediaUrl,
                                    style: { 
                                        width: '100%', 
                                        maxWidth: '400px',
                                        marginBottom: '12px',
                                    }
                                }),
                                wp.element.createElement('div', {
                                    style: { marginTop: '12px' }
                                },
                                    wp.element.createElement(MediaUpload, {
                                        onSelect: onSelectMedia,
                                        allowedTypes: ['audio'],
                                        value: mediaId,
                                        render: function(obj) {
                                            return wp.element.createElement(Button, {
                                                onClick: obj.open,
                                                className: 'button',
                                                style: { marginRight: '8px' }
                                            },
                                                __('Change Audio', 'song-voter-widget')
                                            );
                                        }
                                    }),
                                    wp.element.createElement(Button, {
                                        onClick: function() {
                                            setAttributes({ mediaId: 0, mediaUrl: '' });
                                        },
                                        className: 'button',
                                    },
                                        __('Remove', 'song-voter-widget')
                                    )
                                )
                            )
                        )
                    )
                )
            );
        },
        
        save: function() {
            // Dynamic block - rendered via PHP
            return null;
        },
    });
})(window.wp);
